/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.shader.program;

import icyllis.modernui.graphics.shader.ShaderProgram;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL43C;

public class RectProgram
extends ShaderProgram {
    public static final ResourceLocation VERT = new ResourceLocation("modernui", "shaders/rect.vert");
    public static final ResourceLocation VERT_TEX = new ResourceLocation("modernui", "shaders/rect_tex.vert");
    private static RectProgram sFill;
    private static FillTex sFillTex;
    private static Feathered sFeathered;

    private RectProgram(@Nonnull ResourceLocation vert, @Nonnull ResourceLocation frag) {
        super(vert, frag);
    }

    public static void createPrograms() {
        if (sFill == null) {
            sFill = new RectProgram(VERT, new ResourceLocation("modernui", "shaders/rect_fill.frag"));
            sFillTex = new FillTex();
            sFeathered = new Feathered();
        }
    }

    public static RectProgram fill() {
        return sFill;
    }

    public static RectProgram fillTex() {
        return sFillTex;
    }

    public static Feathered feathered() {
        return sFeathered;
    }

    public static class Feathered
    extends RectProgram {
        private Feathered() {
            super(VERT, new ResourceLocation("modernui", "shaders/rect_fill_v.frag"));
        }

        public void setThickness(float thickness) {
            GL43C.glUniform1f((int)0, (float)thickness);
        }

        public void setInnerRect(float left, float top, float right, float bottom) {
            GL43C.glUniform4f((int)1, (float)left, (float)top, (float)right, (float)bottom);
        }
    }

    private static class FillTex
    extends RectProgram {
        private FillTex() {
            super(VERT_TEX, new ResourceLocation("modernui", "shaders/rect_fill_tex.frag"));
        }

        @Override
        public void link(IResourceManager manager) throws IOException {
            super.link(manager);
            GL43C.glProgramUniform1i((int)this.mId, (int)0, (int)0);
        }
    }
}

